<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use App\Models\RowsModel;

class RowsController extends ResourceController
{

    
    public function index()
    {
        $model = new RowsModel();
		$data = [
			'title'=> 'سطرها',
			'jdate'=> new \App\Libraries\JDate(),
			'rows'=>$model->findAll()
		];
	echo view('rows/main', $data);
    }

    
    public function show($id = null)
    {
        echo $id.'show';
    }

    
    public function new()
    {
        echo 'new';
    }

    
    public function create()
    {
        $model = new RowsModel();
	$relModel = new \App\Models\RelsModel();
	$doc_num = $this->request->getVar('doc_num');
	$last_row = $model->select(['row_num'])->where('doc_num', $doc_num)->orderBy('row_num', 'DESC')->first();
	if(empty($last_row)){ $last_row_num = 1; } else { $last_row_num = $last_row->row_num + 1; }
	$data = [
	    'operator_id' => 220,
	    'doc_num' => $this->request->getVar('doc_num'),
	    'row_num' => $last_row_num, 
	    'part_index' => '402'.sprintf('%04d',$doc_num).sprintf('%03d', $last_row_num),
	    'parent_coding' => $this->request->getVar('parent_coding'),
	    'parent_title' => $this->request->getVar('parent_title'),
	    'coding' => $this->request->getVar('coding'),
	    'coding_title' => $this->request->getVar('coding_title'),
	    'description' => $this->request->getVar('description'),
	    'debit' => str_replace(',', '', $this->request->getVar('debit')),
	    'credit' => str_replace(',', '', $this->request->getVar('credit')),
	    'amount' => $this->request->getVar('amount'),
	    'fi' => $this->request->getVar('fi'),
	    'status' => 0,
	    'section' => 0,
	];
	
        $model->save($data);
	$relExists = $relModel->select(['id', 'counter'])->where(['coding'=> $data['coding'], 'parent_coding'=>$data['parent_coding']])->first();
	if(empty($relExists)){
	    $relData = [
		'coding' => $data['coding'],
		'coding_title' => $data['coding_title'],
		'parent_coding' => $data['parent_coding'],
		'parent_title' => $data['parent_title'],
		'counter' => 0,
		'created_at' => time()
	    ];
	    $relModel->save($relData);
	} else {
	    $relData = ['counter' => $relExists->counter+1];
	    $relModel->update($relExists->id, $relData);
	}
	if(empty($model->errors())){
	    echo view('rows/table', [
		    'row'=>$model->find($model->getInsertID()),
		    'jdate'=> new \App\Libraries\JDate()
		]);
	} else {
	    return $this->failValidationErrors($model->errors());
	}
    }

	public function factors($id=null){
		$model = new RowsModel();
		$data = [
			'title'=> 'سطرها',
			'jdate'=> new \App\Libraries\JDate(),
			'rows'=>$model->findAll()
		];
	echo view('factors/main', $data);
	}

    
    public function edit($id = null)
    {
        echo $id;
    }

    public function update($id = null)
    {
        //
    }

    
    public function delete($id = null)
    {
        //
    }
    
    public function getDetailBook($coding) {
	$model = new RowsModel();
	echo view('detailes/book', ['book'=>$model->select()->where('coding', $coding)->findAll()]);
    }
}
