<?php

namespace App\Models;

use CodeIgniter\Model;

class RowsModel extends Model
{
    protected $table            = 'tally__rows';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['operator_id', 'doc_num', 'row_num', 'part_index', 'factor_num', 'parent_coding', 'parent_title', 'coding', 'coding_title', 'description', 'debit', 'credit', 'amount', 'fi', 'status', 'section', 'created_at'];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'int';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
	'operator_id' => 'required',
	'doc_num' => 'required|max_length[5]',
	'row_num' => 'required|max_length[5]',
	'part_index' => 'required|max_length[11]|is_unique[tally__rows.part_index]',
	'parent_coding' => 'required|max_length[5]',
	'parent_title' => 'required',
	'coding' => 'required',
	'coding_title' => 'required',
	'status' => 'required',
    ];
    protected $validationMessages   = [
	'operator_id' => [
	    'required' => 'لطفا وارد شويد'
	],
	'doc_num' => [
	    'required'=>'شماره سند وارد نشده',
	    'max_length'=>'طول شماره سند بيشتر از حد مجاز است',
	    'min_length'=>'طول شماره سند کمتر از حد مجاز است',
	],
	'row_num' => [
	    'required'=>'شماره رديف وارد نشده',
	    'max_length'=>'شماره رديف بيشتر از حد مجاز است',
	    'min_lenght'=>'شماره رديف کمتر از حد مجاز است'
	],
	'part_index' => [
	    'required'=>'کليد پارتيشن وارد نشده',
	    'max_length'=>'طول کليد پارتيشن بيشتر از حد مجاز است',
	    'min_lenght'=>'طول کليد پارتيشن کمتر از حد مجاز است'
	],
	'parent_coding' => [
	    'required'=>'کدينگ والد وارد نشده',
	    'max_length'=>'طول کدينگ والد بيشتر از حد مجاز است',
	    'min_lenght'=>'طول کدينگ والد کمتر از حد مجاز است'
	],
	'parent_title' => [
	    'required'=>'عنوان والد وارد نشده'
	],
	'coding' => [
	    'required'=>'کدينگ تفصيلي وارد نشده'
	],
	'coding_title' => [
	    'required'=>'عنوان تفصيلي وارد نشده'
	],
	'debit' => [
	    'required'=>'بدهکار وارد نشده'
	],
	'credit' => [
	    'required'=>'بستانکار وارد نشده'
	],
	'status' => [
	    'required'=>'وضعيت وارد نشده'
	],
	'created_at'=> [
	    'required'=>'تاريخ وارد نشده'
	]
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [
	'generatePartIindex'
    ];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
    
    protected function generatePartIindex(array $data) {
        var_dump($data);
	return $data;
    }
}
